install.packages("tcltk2")
require(tcltk2)

# load files
tk_messageBox(message="choose your directory")
setwd(choose.dir())
tk_messageBox(message="choose your t-test file ")
data <- read.csv (choose.files(), header=TRUE, sep="\t", stringsAsFactors=FALSE)
tk_messageBox(message="choose your peptides.txt")
peptides <- read.csv (choose.files(), header=TRUE, sep="\t", stringsAsFactors=FALSE)

x <- getwd()
y <- paste(x,"/analysis",sep="")
dir.create(y)
setwd(y)

data$protein.id <- sub(';.*','',data$Protein.IDs)
data$gene.names <- sub(';.*','',data$Gene.names)

change <- grep("^iBAQ.*",colnames(data))
data[, change] <- sapply(data[, change], as.numeric)
change <- grep("^Razor...unique.peptides.*",colnames(data))
data[, change] <- sapply(data[, change], as.numeric)

vec <- which(data$gene.names == "")									
for (z in 1:length(vec)) {
motif <- sub('-.*','',data$protein.id[vec[z]])
rows <- grep(motif, data$Protein.IDs)
filtered <- data[rows,]
new <- unlist(filtered$gene.names)
new1 <- unique(new)
newest <- paste(new1, collapse=";")
data$gene.names[vec[z]] <- newest
}

data$gene.names <- sub(';.*','',data$gene.names)
vec <- which(data$gene.names == "")	
data$gene.names[vec] <- data$protein.id[vec]

select <- subset(data, (Significant == "+" & Difference > "0"))

for (j in 1:nrow(select)) { 

a <- select$protein.id[j]
rows <- grep(paste(a,";","|",a,"$",sep=""), peptides$Proteins)
filtered <- peptides[rows,]
new1 <- unlist(strsplit(filtered$Proteins,";"))
new <- unique(new1)
newest <- paste(new, collapse=";")
select$shared[j] <- newest
print(j)
}

select$unique <- "yes"
select$unique[select$Peptides != select$Unique.peptides] <- "no"
select$unique[select$Peptides != select$Unique.peptides & select$Razor...unique.peptides > select$Unique.peptides] <- "no-extra"
select$unique[select$Peptides != select$Unique.peptides & select$Razor...unique.peptides == select$Unique.peptides] <- "no-less"

write.table(select, "interactions_w_shared.txt", sep="\t", row.names=FALSE)

select_save <- select
select <- subset(select, !duplicated(select$gene.names) & gene.names!="") 

ibaq <- select[1,]
cols <- grep("^iBAQ.*",colnames(select))

for (l in 1:nrow(select)) {
inter <- select[1,]
if (select$unique[l] == "yes") {
ibaq[l,] <- select[l,]

} else {
split <- strsplit(select$shared[l],";")[[1]]
share <- subset(split, !duplicated(split))

for (m in 1:length(share)){
rows <- grep(paste(share[m],"$",sep=""),data$protein.id)

if (length(rows) > 1) {
temp <- data[rows,]
inter[m,cols] <- colSums(temp[cols])
new <- unlist(temp$protein.id)
new1 <- unique(new)
newest <- paste(new1, collapse=";")
inter$protein.id[m] <- newest
nev <- unlist(unlist(strsplit(temp$gene.names,";")))
nev1 <- unique(nev)
nevest <- paste(nev1, collapse=";")
inter$gene.names[m] <- nevest
c <- paste(newest,".txt",sep="")
write.table(temp, c, sep="\t", row.names=FALSE)
paste("happens")

} else {
if (length(rows) == 1) {
inter[m,] <- data[rows,]
} else {
inter[m,cols] <- rep(0, each=length(cols))
inter$protein.id[m] <- share[m]

}
}
}
inter <- subset(inter, !duplicated(inter))
row.names(inter) <- inter$protein.id
check <- rowSums(inter[cols])
varz <- which(check != 0)
inter <- inter[varz,]

ibaq[l,cols] <- colSums(inter[cols])
ibaq$Peptides[l] <- colSums(inter["Razor...unique.peptides"])
new <- unlist(inter$protein.id)
new1 <- unique(new)
newest <- paste(new1, collapse=";")
ibaq$protein.id[l] <- newest
nev <- unlist(unlist(strsplit(inter$gene.names,";")))
nev1 <- unique(nev)
nevest <- paste(nev1, collapse=";")
ibaq$gene.names[l] <- nevest

c <- paste(newest,".txt",sep="")
write.table(inter, c, sep="\t", row.names=FALSE)

}
print(l)
}

for (p in 1:nrow(ibaq)){
ibaq$key[p] <- paste(ibaq[p,cols],collapse=":")
}
minus <- subset(ibaq, !duplicated(ibaq$key))
ibaq <- minus[grep("^iBAQ.*|^Peptides$|^protein.id$|^gene.names$",colnames(minus))]
write.table(ibaq, "iBAQ.txt", sep="\t", row.names=FALSE)

